$(function() {
    var colors = ['#3366CC', '#FF1493'];
    $.ajax({
        url: '/getGenderCount',
        method: 'GET',
        success: function(data) {
           

            // Donut chart data
            var donutData = [{
                    label: "ذكر",
                    value: data.maleCount
                },
                {
                    label: "انثى",
                    value: data.femaleCount
                }
            ];

            var donutOptions = {
                resize: true,
                colors: colors
            };

            // Plot the Donut chart
            Morris.Donut({
                element: 'morris-donut-chart',
                data: donutData,
                resize: true,
                colors: colors ,
            });
        },
        error: function(xhr, status, error) {
            console.error('Error fetching data:', error);
        }
    });
});
$(function () {
    function renderChart() {
        // AJAX request to fetch data from the server
        $.ajax({
            url: '/get-user-data',
            method: 'GET',
            success: function (data) {
                var currentYear = new Date().getFullYear();

                // Transform data
                var transformedData = [];
                for (var year = 2020; year <= currentYear; year++) {
                    var yearData = data.find(function (item) {
                        return item.year == year;
                    });

                    transformedData.push([
                        new Date(year, 0, 0).getTime(),
                        yearData ? yearData.count : 0,
                    ]);
                }

                var barData = {
                    label: "عدد المستخدمين",
                    data: transformedData,
                };

                var barOptions = {
                    series: {
                        bars: {
                            show: true,
                            barWidth: 8000000000,
                        },
                    },
                    xaxis: {
                        mode: "time",
                        timeformat: "%Y",
                        minTickSize: [1, "year"],
                        min: new Date(2020, 0, 0).getTime(),
                        max: new Date(currentYear + 1, 0, 0).getTime(),
                    },
                    yaxis: {
                        position: "left",
                    },
                    grid: {
                        hoverable: true,
                    },
                    legend: {
                        show: false,
                    },
                    tooltip: true,
                    tooltipOpts: {
                        content: "السنة: %x, عدد المستخدمين: %y",
                    },
                };

                // Plot the bar chart
                $.plot($("#flot-bar-chart"), [barData], barOptions);
            },
            error: function (xhr, status, error) {
                console.error("Error fetching data:", error);
            },
        });
    }

    // Render the chart on load
    renderChart();

    // Re-render the chart on window resize
    $(window).resize(function () {
        renderChart();
    });
});

