<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use App\Models\SmsInbox;
use Carbon\Carbon;
class WebhookController extends Controller
{
    public function inbound(Request $request)
    {
        Log::info('Inbound SMS received', $request->all());

        SmsInbox::create([
            'from'           => $request->input('msisdn'),
            'to'             => $request->input('to'),
            'network'        => $request->input('network'),
            'network_name'   => $request->input('network_name'),
            'country'        => $request->input('country'),
            'country_name'   => $request->input('country_name'),
            'message'        => $request->input('text'),
            'received_at'    => $request->input('date_received') 
                                  ? Carbon::parse($request->input('date_received'))
                                  : now(),
            'price'          => $request->input('total_price') ?? '0.00',
            'message_id'     => $request->input('messageId') ?? $request->input('message_id'),
        ]);

        return response('OK', 200);
    }
}
