<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
  
   public function up(): void
{
    Schema::create('sms_inbox', function (Blueprint $table) {
        $table->id();
        $table->string('from')->nullable();             // رقم المرسل
        $table->string('to')->nullable();               // رقم المستلم (رقمك Vonage)
        $table->string('network')->nullable();          // نوع الشبكة (CA-FIXED / CA-VOIP...)
        $table->string('network_name')->nullable();     // اسم الشبكة مثل "Canada Landline"
        $table->string('country')->nullable();          // رمز الدولة (CA)
        $table->string('country_name')->nullable();     // اسم الدولة (Canada)
        $table->text('message')->nullable();            // نص الرسالة
        $table->timestamp('received_at')->nullable();   // وقت الاستلام (UTC)
        $table->string('price')->nullable();            // السعر (مثلاً €0)
        $table->string('message_id')->nullable();       // معرف الرسالة (من Vonage)
        $table->timestamps();                           // created_at / updated_at
    });
}


  
    public function down(): void
    {
        Schema::dropIfExists('sms_inbox');
    }
};
